using System;
using System.IO;
using System.Xml;
using System.Text;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Security.Cryptography;

[AttributeUsage(AttributeTargets.Method)]
public class EncryptionExtensionAttribute : SoapExtensionAttribute {
	private int priority;
	private EncryptMode encryptionMode = EncryptMode.None;
	private DecryptMode decryptionMode = DecryptMode.None;
	private Target target = Target.Method;

	public override Type ExtensionType {
		get { return typeof(EncryptionExtension); }
	}

	public override int Priority {
		get { 
			return priority; 
		}
		set { 
			priority = value; 
		}
	}

	public EncryptMode Encrypt {
		get {
			return encryptionMode;
		}
		set {
			encryptionMode = value;
		}
	}

	public DecryptMode Decrypt {
		get {
			return decryptionMode;
		}
		set {
			decryptionMode = value;
		}
	}

	public Target Target {
		get {
			return target;
		}
		set {
			target = value;
		}
	}

}

public enum DecryptMode {
	None,
	Response,
	Request
}

public enum EncryptMode {
	None,
	Response,
	Request
}

public enum Target {
	Envelope,
	Body,
	Method
}